//	TorusGamesNone.c
//
//	Supplies harmless default values when no game is active.
//	Providing such values here keeps the higher-level code cleaner.
//
//	© 2021 by Jeff Weeks
//	See TermsOfUse.txt

#include "TorusGames-Common.h"
#include "GeometryGamesUtilities-Common.h"


unsigned int GetNum2DNoneBackgroundTextureRepetitions(void)
{
	return 1;	//	value unused
}

void Get2DNoneKleinAxisColors(
	float	someKleinAxisColors[2][4])	//	premultiplied alpha
{
	//	colors unused
	
	someKleinAxisColors[0][0] = 1.00;
	someKleinAxisColors[0][1] = 1.00;
	someKleinAxisColors[0][2] = 0.00;
	someKleinAxisColors[0][3] = 1.00;

	someKleinAxisColors[1][0] = 0.50;
	someKleinAxisColors[1][1] = 1.00;
	someKleinAxisColors[1][2] = 1.00;
	someKleinAxisColors[1][3] = 1.00;
}


unsigned int GetNum2DNoneSprites(void)
{
	return 0;
}

void Get2DNoneSpritePlacements(
	ModelData		*md,				//	input
	unsigned int	aNumSprites,		//	input
	Placement2D		*aPlacementBuffer)	//	output;  big enough to hold aNumSprites Placement2D's
{
	UNUSED_PARAMETER(md);
	UNUSED_PARAMETER(aNumSprites);
	UNUSED_PARAMETER(aPlacementBuffer);

	GEOMETRY_GAMES_ASSERT(
		md->itsGame == GameNone,
		"GameNone must be active");

	GEOMETRY_GAMES_ASSERT(
		aNumSprites == GetNum2DNoneSprites(),
		"Internal error:  wrong buffer size");
}
